rm(list =ls())

library(ggplot2)
library(stringr)
library(ggpubr)
library(latex2exp)

f1 = function(x) return( (x^2)*( 2^(x-1) - (x-0.5)^2 )*exp(x)-0.5424 )
f2 = function(x) return( 12*((x-0.5)^2) - 1 )
f3 = function(x) return( 3*(x^2)*(2^(x-1))*cos(15*x) - 0.1002 )
f4 = function(x) return( 2*x- 1 )
f5 = function(x) return( 8*(x-0.7)^3 + 0.464  )
integrate( function(x) return(f1(x) ), 0, 1 )
# integrate( f3,0, 1 )

CoefK = function(f, K = 101){
  #return the first K coefficients of function f
  #K should be odd
  Coef=rep(0,K)
  Coef[1] = integrate( f, 0, 1 )$value
  for (k in 1:((K-1)/2) ){
    Coef[2*k] = integrate( function(x) return( sqrt(2)*f(x)*cos(2*pi*k*x) ),
                           0, 1, subdivisions=300 )$value
    Coef[2*k+1]=integrate( function(x) return( sqrt(2)*f(x)*sin(2*pi*k*x) ),
                           0, 1, subdivisions=300 )$value
  }
  return(Coef)
}


K=101
alpha=1/2; muK = rep(0,K); muK[1]= 1
for (k in 1:((K-1)/2) ){ muK[2*k] =muK[2*k+1] = (k)^(-2*alpha) }
sum( CoefK(f=f1)^2/muK )
sum( CoefK(f=f2)^2/muK )
sum( CoefK(f=f3)^2/muK )
sum( CoefK(f=f4)^2/muK )
sum( CoefK(f=f5)^2/muK )


Detect = function(x, k, n, p, s=5, delta = 0.05, lam=1 ){
  Exk = sum(x[1:k]^2)
  eta = ( Exk-k/n >= ( lam* log(p/delta)+ sqrt(lam* k*log(p/delta)) )/n )
  return( eta )
}

Adadetect = function(x, n, p, s=5, delta = 0.05, lam=1, C=1/3){
  temp = ceiling( C * log2( n^2 / log(8*p*log(n)/delta) ) )
  etavec = rep( 0, length(temp) )
  for( i in 1:temp ){
    etavec[i] = Detect(x, k=2^i, n, p, s=5, delta=delta/4/log(n), lam )
  }
  return( max(etavec))
}


##### 1. Different dimension and different signal strength #####
# 18.5 min
t1 = Sys.time()
n=300; Kmax = 51; MC = 300;
strengthset =( (1:15)/15 ) #strength para
pset = c(10, 1e2, 1e3, 1e4) # dim para
# pset = c(15, 50, 150, 500, 1500, 5000) # dim para

# collect wrong recovery probability
detstr = matrix(0, length(pset), length(strengthset))
detsd  = matrix(0, length(pset), length(strengthset))

# collect FDR + FNR
FDRrisk = matrix(0, length(pset), length(strengthset))
FDRsd = matrix(0, length(pset), length(strengthset))

C1max = CoefK(f1, K=Kmax)
C2max = CoefK(f2, K=Kmax)
C3max = CoefK(f3, K=Kmax)
C4max = CoefK(f4, K=Kmax)
C5max = CoefK(f5, K=Kmax)

for(pind in 1:length(pset) ){ # for different dimension
  p = pset[pind]
  dsloss1 = dsloss2 = matrix( 0, MC, length(strengthset) )
  dp = rep(0,p); dp[1:5] = 1
  
  for( sind in 1:length(strengthset) ){ # for different signal strength
    a = strengthset[sind]
    for( i in 1:MC ){
      # get Kmax*p observation
      set.seed( pind*1e3 + i*sind*3 )
      X = matrix( rnorm(Kmax*p,0,1/sqrt(n)), Kmax, p )
      X[,1:5] = X[,1:5] + cbind(  C1max, C2max, C3max, 
                                  C4max, C5max) * a #consider the signal strength
      K = ceiling( 1/2*( n^2/ log(2*p/0.05))^(1/3) )
      
      # support recovery
      etahat1 = apply(X, 2, function(x){ 
        return( Detect(x, k=K, n, p, s=5, delta = 0.05, lam=1.6 )) } )
      # 5.4 9:19 1.4 \to 1.5
      dsloss1[i, sind] = 1-all( etahat1==dp )
      
      # sparse multiple testing
      K = ceiling( 1/2*( n^2/ log(2*p/0.05/5))^(1/3) )
      etahat2 = apply(X, 2, function(x){ 
        return( Detect(x, k=K, n, p, s=5, delta = 0.05*5, lam=1.6 )) } )
      dsloss2[i, sind] = sum(etahat2[6:p]) / max(1, sum(etahat2)) + (5-sum(etahat2[1:5]))/5
      
      
      cat("MC:", i,"/", MC, ";",
          "signal:", sind, "/", length(strengthset), ";",
          "p =", p, "\r")
    }
  }
  detstr[pind,] = colMeans(dsloss1)
  detsd[pind, ] = apply(dsloss1, 2, sd)
  
  FDRrisk[pind,] = colMeans(dsloss2)
  FDRsd[pind, ] = apply(dsloss2, 2, sd)
}
Sys.time() - t1

Data1left = data.frame("a"= rep(strengthset, length(pset)) , 
                       "Dimension"=rep( str_c("p=",pset, ""), each= length(strengthset) ), 
                       "Wrong Recovery Frequence" = c( t(detstr)),
                       "se" = c( t(detsd))/sqrt(MC) )

p1left<-ggplot(Data1left , aes(x = a, y = Wrong.Recovery.Frequence, 
                               group = Dimension, color = Dimension, 
                               linetype = Dimension, shape = Dimension))+
  geom_errorbar(aes(ymin= Wrong.Recovery.Frequence -2*se, 
                    ymax= Wrong.Recovery.Frequence +2*se),
                colour="black", width=3e-2)+
  geom_line(size=1)+
  geom_point(size = 2)+
  #scale_shape_manual( )+
  guides(fill = guide_legend(nrow = 1))+
  scale_linetype_manual(values=rep("solid", length(pset)) )+
  scale_color_manual(values=1:length(pset))+
  # scale_color_hue(l=70, c=60)+
  theme_bw()+theme(legend.position = "bottom", 
                   legend.key.size = unit(20, "pt"), 
                   legend.box.spacing = unit(0, 'pt'))+
  ylab("Hamming Loss")+xlab("Signal Strength a")+
  ggtitle("Support Recovery")+
  theme(plot.title = element_text(hjust = 0.5), 
        text = element_text(size = 16))
p1left

Data1right = data.frame("a"= rep(strengthset, length(pset)) , 
                        "Dimension"=rep( str_c("p=",pset, ""), each= length(strengthset) ), 
                        "Combinerisk" =  c( t(FDRrisk )),
                        "se" = c( t(FDRsd))/sqrt(MC) )
p1right <-ggplot(Data1right, aes(x = a, y = Combinerisk, group = Dimension,
                                 color = Dimension, linetype = Dimension, shape = Dimension))+
  geom_errorbar(aes(ymin= Combinerisk -2*se, 
                    ymax= Combinerisk +2*se),
                colour="black", width=3e-2)+
  geom_line(size=1)+
  geom_point(size = 2)+
  #scale_shape_manual( )+
  guides(fill = guide_legend(nrow = 1))+
  scale_linetype_manual(values=rep("solid", length(pset)) )+
  scale_color_manual(values=1:length(pset))+
  # scale_color_hue(l=70, c=60)+
  theme_bw()+theme(legend.position = "bottom", 
                   legend.key.size = unit(20, "pt"), 
                   legend.box.spacing = unit(0, 'pt'))+
  ylab("FNR + FDR Loss")+xlab("Signal Strength a")+
  ggtitle("Sparse Multiple Testing")+
  theme(plot.title = element_text(hjust = 0.5),
        text = element_text(size = 16))
p1right

p1 =ggarrange(p1left, p1right, common.legend = T, legend="bottom")
p1

ggsave(file = "./p1.pdf", 
       dpi = 600, p1, height =5, width = 10)



##### 2. Different methods and different n #####
# 3.5 min *2
t1 = Sys.time()
p = 500; Kmax = 257; MC = 300;
nset = (1:15)*20 #strength para
detn = matrix(0, length(nset), 4)
detsd = matrix(0, length(nset), 4)
colnames(detn) = c("rate optimal", "adaptive", "univariate", "sub-optimal")

C1max = CoefK(f1, K=Kmax)
C2max = CoefK(f2, K=Kmax)
C3max = CoefK(f3, K=Kmax)
C4max = CoefK(f4, K=Kmax)
C5max = CoefK(f5, K=Kmax)

for(nind in 1:length(nset) ){ # for different dimension
  n = nset[nind]
  dnloss = matrix( 0, MC, 4 )
  dp = rep(0,p); dp[1:5] = 1
  for( i in 1:MC ){
    # get Kmax*p observation
    set.seed( nind*1e4 + i*nind*2 )
    X = matrix( rnorm(Kmax*p,0,1/sqrt(n)), Kmax, p )
    X[,1:5] = X[,1:5] + cbind( C1max, C2max, C3max, 
                               C4max, C5max ) * 1 #consider the signal strength
    # rate optimal
    K1 = ceiling( 1/2*( n^2/ log(2*p/0.05))^(1/3) )
    etahat1 = apply(X, 2, function(x){ 
      return(Detect(x, k=K1, n, p, s=5, delta = 0.05, lam=1.5)) })
    dnloss[i, 1] = 1-all( etahat1==dp )
    
    # adaptive
    etahat2 = apply(X, 2, function(x){ 
      return( Adadetect(x, n, p, s=5, delta = 0.05, lam=1.5, C=1/3)) })
    dnloss[i, 2] = 1-all( etahat2==dp )
    
    # univariate
    K2 = ceiling( n^(2/3) )
    etahat3 = apply(X, 2, function(x){ 
      return(Detect(x, k=K2, n, p, s=5, delta = 0.05, lam=1.5)) })
    dnloss[i, 3] = 1-all( etahat3==dp )
    
    # based on optimal estimation
    K3 = ceiling(2*n^(1/2) )
    etahat4 = apply(X, 2, function(x){ 
      return(Detect(x, k=K3, n, p, s=5, delta = 0.05, lam=1.5)) })
    dnloss[i, 4] = 1-all( etahat4==dp )
    
    cat("MC:", i,"/", MC, ";", "n =", n, "\r")
  }
  detn[nind,] = colMeans(dnloss)
  detsd[nind,] = apply(dnloss, 2, sd)
}
detn
Sys.time() - t1

# shat1[nind,] = colMeans(shatmat1)
# shat2[nind,] = colMeans(shatmat2)
# shat3[nind,] = colMeans(shatmat3)

Data2left = data.frame("n"= rep(nset, 4) , 
                       "Method"=rep( c("Optimal", "Adaptation",
                                       "Univariate", "Suboptimal"), 
                                     each=length(nset) ), 
                       "wr" = c(detn),
                       "se" = c(detsd)/sqrt(MC) )

p2left = ggplot(Data2left, aes(x = n, y = wr , group = Method,
                               color = Method, linetype = Method,
                               shape = Method))+
  geom_errorbar(aes(ymin= wr - 1*se, 
                    ymax= wr + 1*se),
                colour="black", width=10)+
  geom_line(size=1)+
  geom_point(size = 2)+
  #scale_shape_manual( )+
  guides(fill = guide_legend(nrow = 1))+
  scale_linetype_manual(values=rep("solid", 4) )+
  scale_color_manual(values=1:4)+
  # scale_color_hue(l=70, c=60)+
  theme_bw()+theme(legend.position = "bottom", 
                   legend.key.size = unit(20, "pt"), 
                   legend.box.spacing = unit(0, 'pt'))+
  ylab("Hamming Loss")+xlab("n")+
  ggtitle("Support Recovery")+
  theme(plot.title = element_text(hjust = 0.5),
        text = element_text(size = 16))
p2left


t1 = Sys.time()
p = 500; Kmax = 257; MC = 300;
nset = (1:15)*20 #strength para
FDRn = matrix(0, length(nset), 4)
FDRnsd = matrix(0, length(nset), 4)
colnames(FDRn) = c("rate optimal", "adaptive", "univariate", "sub-optimal")

for(nind in 1:length(nset) ){ # for different dimension
  n = nset[nind]
  fdrloss = matrix( 0, MC, 4 )
  dp = rep(0,p); dp[1:5] = 1
  for( i in 1:MC ){
    # get Kmax*p observation
    set.seed( nind*1e4 + i*nind*2 )
    X = matrix( rnorm(Kmax*p,0,1/sqrt(n)), Kmax, p )
    X[,1:5] = X[,1:5] + cbind( C1max, C2max, C3max, 
                               C4max, C5max ) * 1 #consider the signal strength
    # rate optimal
    K1 = ceiling( 1/2*( n^2/ log(2*p/0.05/5))^(1/3) )
    etahat1 = apply(X, 2, function(x){ 
      return(Detect(x, k=K1, n, p, s=5, delta = 0.05*5, lam=1.5)) })
    fdrloss[i, 1] = sum(etahat1[6:p]) / max(1, sum(etahat1)) + (5-sum(etahat1[1:5]))/5
    
    # adaptive
    etahat2 = apply(X, 2, function(x){ 
      return( Adadetect(x, n, p, s=5, delta = 0.05*5, lam=1.5, C=1/2)) })
    fdrloss[i, 2] = sum(etahat2[6:p]) / max(1, sum(etahat2)) + (5-sum(etahat2[1:5]))/5
    
    # univariate
    K2 = ceiling( n^(2/3) )
    etahat3 = apply(X, 2, function(x){ 
      return(Detect(x, k=K2, n, p, s=5, delta = 0.05*5, lam=1.5)) })
    fdrloss[i, 3] = sum(etahat3[6:p]) / max(1, sum(etahat3)) + (5-sum(etahat3[1:5]))/5
    
    # based on optimal estimation
    K3 = ceiling(2*n^(1/2) )
    etahat4 = apply(X, 2, function(x){ 
      return(Detect(x, k=K3, n, p, s=5, delta = 0.05*5, lam=1.5)) })
    fdrloss[i, 4] = sum(etahat4[6:p]) / max(1, sum(etahat4)) + (5-sum(etahat4[1:5]))/5
    
    cat("MC:", i,"/", MC, ";", "n =", n, "\r")
  }
  FDRn[nind,] = colMeans(fdrloss)
  FDRnsd[nind,] = apply(fdrloss, 2, sd)
}
FDRn
Sys.time() - t1

Data2right = data.frame("n"= rep(nset, 4) , 
                        "Method"=rep( c("Optimal", "Adaptation",
                                        "Univariate", "Suboptimal"), 
                                      each=length(nset) ), 
                        "fdr" = c(FDRn),
                        "se" = c(FDRnsd)/sqrt(MC) )

p2right = ggplot(Data2right, aes(x = n, y = fdr , group = Method,
                                 color = Method, linetype = Method, 
                                 shape = Method))+
  geom_errorbar(aes(ymin= fdr - 1*se, 
                    ymax= fdr + 1*se),
                colour="black", width=10)+
  geom_line(size=1)+
  geom_point(size = 2)+
  #scale_shape_manual( )+
  guides(fill = guide_legend(nrow = 1))+
  scale_linetype_manual(values=rep("solid", 4) )+
  scale_color_manual(values=1:4)+
  # scale_color_hue(l=70, c=60)+
  theme_bw()+theme(legend.position = "bottom", 
                   legend.key.size = unit(20, "pt"), 
                   legend.box.spacing = unit(0, 'pt'))+
  ylab("FNR + FDR Loss")+xlab("n")+
  ggtitle("Sparse Multiple Testing")+
  theme(plot.title = element_text(hjust = 0.5),
        text = element_text(size = 16))
p2right

p2 =ggarrange(p2left, p2right, common.legend = T, legend="bottom")
p2
ggsave(file = "./p2.pdf", 
       dpi = 600, p2, height =5, width = 10)




#### 3. Different methods and smoothness #####

# from alpha smoothness to beta smoothness
tran = function(f, K=101, alpha=1/2, b=1){
  C1 = CoefK(f, K)
  Cb1 = rep(0,K); Cb1[1] = C1[1]
  for (k in 1:((K-1)/2) ){
    Cb1[2*k] = C1[2*k] * k^(alpha-b) 
    Cb1[2*k+1] = C1[2*k+1] * k^(alpha-b) 
  }
  return(Cb1)
}

# K=201; alpha =1/2
# muK = rep(0,K); muK[1]= 1
# for (k in 1:((K-1)/2) ){ muK[2*k] =muK[2*k+1] = (k)^(-2*alpha) }
# 
# b = 3
# muKb = rep(0,K); muKb[1]= 1
# for (k in 1:((K-1)/2) ){ muKb[2*k] =muKb[2*k+1] = k^(-2*b) }
# 
# sum( C5^2/muK )
# sum( tran(f5,K, alpha=1/2, b=b)^2/muKb )

t1 = Sys.time()
n=300; p = 500; Kmax = 201; MC = 1e3; alpha =1/2
bset = seq(0.2, 1, l=10) #strength para
detb = matrix(0, length(bset), 4)
detbsd = matrix(0, length(bset), 4)
colnames(detb) = c("rate optimal", "adaptive", "univariate", "suboptimal")

for(bind in 1:length(bset) ){ # for different smoothness
  b = bset[bind]
  dbloss = matrix( 0, MC, 4 )
  dp = rep(0,p); dp[1:5] = 1
  for( i in 1:MC ){
    # get Kmax*p observation
    set.seed( bind*1e5 + i*bind*5 )
    X = matrix( rnorm(Kmax*p,0,1/sqrt(n)), Kmax, p )
    X[,1:5] = X[,1:5] + cbind( tran(f1, Kmax, alpha=1/2, b=b),
                               tran(f2, Kmax, alpha=1/2, b=b),
                               tran(f3, Kmax, alpha=1/2, b=b),
                               tran(f4, Kmax, alpha=1/2, b=b),
                               tran(f5, Kmax, alpha=1/2, b=b)) * 1 #consider the signal strength
    # rate optimal
    K1 = ceiling( 1/4*( n^2/ log(p/0.05))^(1/(1+4*b)) )+1
    if(K1 <=6){K1 = K1*2}
    etahat1 = apply(X, 2, function(x){ 
      return(Detect(x, k=K1, n, p, s=5, delta = 0.05, lam=1.5)) })
    dbloss[i, 1] = 1-all( etahat1==dp )
    
    # adaptive
    etahat2 = apply(X, 2, function(x){ 
      return( Adadetect(x, n, p, s=5, delta = 0.05, lam=1.5, C=1/3)) })
    dbloss[i, 2] = 1-all( etahat2==dp )
    
    # unvariate
    K2 = min(ceiling(1/2* n^(2/(1+4*b))), Kmax)
    etahat3 = apply(X, 2, function(x){ 
      return(Detect(x, k=K2, n, p, s=5, delta = 0.05, lam=1.5)) })
    dbloss[i, 3] = 1-all( etahat3==dp )
   
    # based on optimal estimation
    K3 = min(ceiling(2*n^(1/(1+2*b)) ), Kmax)
    etahat4 = apply(X, 2, function(x){ 
      return(Detect(x, k=K3, n, p, s=5, delta = 0.05, lam=1.5)) })
    dbloss[i, 4] = 1-all( etahat4==dp ) 
    
    cat("MC:", i,"/", MC, ";", "beta =", b, "\r")
  }
  detb[bind,] = colMeans(dbloss)
  detbsd[bind,] = apply(dbloss, 2, sd)
}
detb
Sys.time() - t1

Data3left = data.frame("b"= rep(bset, 4) , 
                       "Method"=rep( c("Optimal", "Adaptation",
                                       "Univariate", "Suboptimal"), 
                                     each=length(bset) ), 
                       "wr" = c(detb),
                       "se" = c(detbsd)/sqrt(MC) )

p3left = ggplot(Data3left, aes(x = b, y = wr , group = Method,
                               color = Method, linetype = Method, 
                               shape = Method))+
  geom_errorbar(aes(ymin= wr - 1*se, 
                    ymax= wr + 1*se),
                colour="black", width=3e-2)+
  geom_line(size = 1)+
  geom_point(size = 2)+
  #scale_shape_manual( )+
  guides(fill = guide_legend(nrow = 1))+
  scale_linetype_manual(values=rep("solid", 4) )+
  scale_color_manual(values=1:4)+
  # scale_color_hue(l=70, c=60)+
  theme_bw()+theme(legend.position = "bottom", 
                   legend.key.size = unit(20, "pt"), 
                   legend.box.spacing = unit(0, 'pt'))+
  ylab("Hamming Loss")+xlab(TeX("Smoothness beta"))+
  ggtitle("Support Recovery")+
  theme(plot.title = element_text(hjust = 0.5),
        text = element_text(size = 16))
p3left


t2 = Sys.time()
n=300; p = 500; Kmax = 201; MC = 1e3; alpha =1/2
bset = seq(0.2, 1, l=10) #strength para
fdrb = matrix(0, length(bset), 4)
fdrbsd = matrix(0, length(bset), 4)
colnames(detb) = c("rate optimal", "adaptive", "univariate", "suboptimal")

for(bind in 1:length(bset) ){ # for different smoothness
  b = bset[bind]
  fdrbloss = matrix( 0, MC, 4 )
  dp = rep(0,p); dp[1:5] = 1
  for( i in 1:MC ){
    # get Kmax*p observation
    set.seed( bind*1e5 + i*bind*5 )
    X = matrix( rnorm(Kmax*p,0,1/sqrt(n)), Kmax, p )
    X[,1:5] = X[,1:5] + cbind( tran(f1, Kmax, alpha=1/2, b=b),
                               tran(f2, Kmax, alpha=1/2, b=b),
                               tran(f3, Kmax, alpha=1/2, b=b),
                               tran(f4, Kmax, alpha=1/2, b=b),
                               tran(f5, Kmax, alpha=1/2, b=b)) * 1 #consider the signal strength
    # rate optimal
    K1 = ceiling( 1/3*( n^2/ log(p/0.05))^(1/(1+4*b)) )+1
    if(K1 <=6){K1 = K1*3/2}
    etahat1 = apply(X, 2, function(x){ 
      return(Detect(x, k=K1, n, p, s=5, delta = 0.05*5, lam=1.5)) })
    fdrbloss[i, 1] = sum(etahat1[6:p]) / max(1, sum(etahat1)) + (5-sum(etahat1[1:5]))/5
    
    # adaptive
    etahat2 = apply(X, 2, function(x){ 
      return( Adadetect(x, n, p, s=5, delta = 0.05*5, lam=1.5, C=1/3)) })
    fdrbloss[i, 2] = sum(etahat2[6:p]) / max(1, sum(etahat2)) + (5-sum(etahat2[1:5]))/5
    
    # univariate
    K2 = min(ceiling(1/2* n^(2/(1+4*b))), Kmax)
    etahat3 = apply(X, 2, function(x){ 
      return(Detect(x, k=K2, n, p, s=5, delta = 0.05*5, lam=1.5)) })
    fdrbloss[i, 3] = sum(etahat3[6:p]) / max(1, sum(etahat3)) + (5-sum(etahat3[1:5]))/5
    
    # based on optimal estimation
    K3 = min(ceiling(2*n^(1/(1+2*b)) ), Kmax)
    etahat4 = apply(X, 2, function(x){ 
      return(Detect(x, k=K3, n, p, s=5, delta = 0.05*5, lam=1.5)) })
    fdrbloss[i, 4] = sum(etahat4[6:p]) / max(1, sum(etahat4)) + (5-sum(etahat4[1:5]))/5
    
    cat("MC:", i,"/", MC, ";", "beta =", b, "\r")
  }
  fdrb[bind,] = colMeans(fdrbloss)
  fdrbsd[bind,] = apply(fdrbloss, 2, sd)
}
fdrb
Sys.time() - t2

Data3right = data.frame("b"= rep(bset, 4) , 
                       "Method"=rep( c("Optimal", "Adaptation",
                                       "Univariate", "Suboptimal"), 
                                     each=length(bset) ), 
                       "wr" = c(fdrb),
                       "se" = c(fdrbsd)/sqrt(MC) )

p3right = ggplot(Data3right, aes(x = b, y = wr , group = Method,
                               color = Method, linetype = Method,
                               shape = Method))+
  geom_errorbar(aes(ymin= wr - 1*se, 
                    ymax= wr + 1*se),
                colour="black", width=3e-2)+
  geom_line(size=1)+
  geom_point(size = 2)+
  #scale_shape_manual( )+
  guides(fill = guide_legend(nrow = 1))+
  scale_linetype_manual(values=rep("solid", 4) )+
  scale_color_manual(values=1:4)+
  # scale_color_hue(l=70, c=60)+
  theme_bw()+theme(legend.position = "bottom", 
                   legend.key.size = unit(20, "pt"), 
                   legend.box.spacing = unit(0, 'pt'))+
  ylab("FDR + FNR Loss")+xlab(TeX("Smoothness beta"))+
  ggtitle("Sparse Multiple Testing")+
  theme(plot.title = element_text(hjust = 0.5),
        text = element_text(size = 16))
# xlab(TeX("Smoothness $\\beta$"))
p3right
  

p3 =ggarrange(p3left, p3right, common.legend = T, legend="bottom")
p3

ggsave(file = "./p3_1e3.pdf", 
       dpi = 600, p3, height =5, width = 10)

